#include <intrins.h>                             // for _nop_();
#include "GLOBAL.H"
#include "USB.H"
#include "MCU.H"


//-----USB.C-----//
extern EP0INFO Ep0;
extern void USB_Int( void );

//-----MOUSE.C-----//
extern void MS_Receive_Data_From_Device( void );

BYTE Wdt;


void Delay_5us( void )                           // 5us at 1T 12Mhz
  { _nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();
    _nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();
    _nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();
    _nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();
    _nop_();_nop_();_nop_();_nop_();_nop_();_nop_();_nop_();
  }


void Delay_Xms( BYTE X )
  { BYTE Cnt;
    
    
    while( X )
      { Cnt = 177;                               // 1ms at 12Mhz
        while( Cnt )
          { Delay_5us();
            Cnt--;
          }
      	X--;
      }
  }


void Reboot_Mcu( BYTE Cmd )
  { ISPCR = Cmd;
  }


void INT_USB(void) interrupt 15 using 3          // 
  { WDTCR = Wdt;                                 // Reset Watch Dog Timer
    USB_Int();
  }


void INT_KB(void) interrupt 13 using 2           // 
  { WDTCR = Wdt;
    
    KBPATN = 0xFF;
    KBCON = 0x00;
    KBMASK = 0x00;
    
    while( 1 )
      { if ( CKCON2 & PLL_RDY )                  // Check PLL ready ?
          break;
      }
    
    if ( Ep0.RWEN )
      USB[UPCON] |= URWU;                        // Set USB into Wake-up mode
  }


void Initial_Mcu( void )
  { IE  = 0x00;	                                 // disable all interrupt
    
    AUXIE = ( EUSB | EKB );                      // Enable USB and KB int
    AUXIP = 0x20;                                // KB high priority
    
    PSW = 0x00;	                                 // bank 0
    
    Wdt = WDTCR;
    Wdt |= 0x37;                                 // Setting and Reset WDT
    
    CKCON = (BYTE)(( 12 - 1 ) << 3);             // CLKin -> Default , OSCDN = 12Mhz - 1
    
    CKCON2 |= EN_PLL;                            // Enalbe EN_PLL ( for USB )
    while( 1 )
      { if ( CKCON2 & PLL_RDY )                  // Check PLL ready ?
          break;
      }
    CKCON2 |= EN_USB;                            // Enalbe EN_USB
    
    USB[ACKCTL] |= EN_DLL;                       // Enable DPLL
    Delay_Xms( 3 );
    USB[ACKCTL] |= UCK_SEL;                      // Switch DPLL to USB
    
    USB[ACKCTL] |= ACKEN;                        // Enable Audio Clock  
    
//    CKCON2 |= OSCDR0;                            // Mini clock output
                                                 // Set Open Drain
    P1M0 = 0x07;                                 // P1.0 ~ P1.2
    P1M1 = 0x07;
    P2M0 = 0xFF;                                 // P2
    P2M1 = 0xFF;
    P3M0 = 0x7F;                                 // P3.0 ~ P3.6 for Keyboard
    P3M1 = 0x7F;
    
    EA  = 1;                                     // enable all interrupt
    
//    Delay_Xms( 255 );
  }